###
# Generic platform tools
###

::namespace eval ::localtool {}
::namespace eval ::gort::platform {}

set ::gort::platform_list {
macosx-universal
linux-glibc2.3-ix86
linux-glibc2.3-x86_64
macosx10.5-i386-x86_64
macosx10.5_x11-i386-x86_64
win32-ix86
win32-x86_64
}

###
# topic: f46f688e26b3d6d6386eb4a777ea14162d7733f2
###
gort::class create ::gort::platform {
  superclass ::gort::platform.meta
  
  constructor {} {}
  
  ###
  # Initialize our picture of the world
  ###
  meta branchset tcl {
    config_flags {}
    version 8.6
    major_version 8
    minor_version 6
    patch_level .4
    fossil_branch release
    platform_source_dir unix
  }
  meta branchset tk {
    config_flags {}
    version 8.6
    major_version 8
    minor_version 6
    patch_level .4
    fossil_branch release
    platform_source_dir unix
  }
  meta branchset platform {
    exe_suffix {}
    platform unix
    platform_source_dir unix
    tcl_platform_dir unix
    tcl_config_flags {}
    tk_config_flags {}
    64bit 1
    windows 0
    system generic
    target generic
    os generic
    os_version {}
    cpu {}
    window_system {}
    fossil_checkout .fslckout
    teacup_profile {}
    mirror_url http://fossil.etoyoc.com/fossil
    prefix /usr/local
  }
  
  method localize {} {
    set try {}
    my define set build {}
    set genus [dict get $::gort::platform odie_genus]
    lappend try ::gort::platform.[::platform::identify]
    lappend try ::gort::platform.$genus
    lappend try ::gort::platform.$::tcl_platform(platform).$genus
    lappend try ::gort::platform.$::tcl_platform(platform)
    lappend try ::gort::platform
    foreach candidate $try {
      if {[info command $candidate] ne {}} {
        oo::objdefine [self] class $candidate
        break
      }
    }
    source [file join ${::gort::home} platform script_platform.tcl]
  }
  
  ###
  # topic: f3ffeba5470a4b95d9b2fef7c6d834a7d8052d57
  ###
  method initialize {} {}
  
  method is_windows {} {
    return 0
  }
  
  ###
  # topic: b675eff5e253             gcee79145bac771e8d3824c9c2e22
  ###
  method odie {} {
    my variable odie
    return [array get odie]
  }

  ###
  # topic: 14d2b0d11366f11c7a870aa869b64266a64b22db
  ###
  method profile_tcl {} {
    my variable profile_tcl
    return [array get profile_tcl]
  }

  ###
  # topic: 91a3cb8a519fe1884fb1170bf25cde17e16d322c
  ###
  method profile_tk {} {
    my variable profile_tk
    return [array get profile_tk]
  }
  
  ###
  # topic: b470ea93e3ae076306f333d6b79920da300de478
  ###
  method default-exec-prefix {} {
    return /usr/local
  }
  

  ###
  # topic: 8b002e4a75f6a131ba48ae99642990a6e8679c63
  ###
  method default-prefix {} {
    return /usr/local
  }
  
  ###
  # topic: 70337e6971b4d62668b10463d568939b90441f41
  ###
  method default-tcl-prefix {} {
    return /usr/local
  }

  ###
  # topic: 8309c737fac511ea8c051f816d468d20128a4e88
  ###
  method getenv {name args} {
    if {[info exists ::env($name)]} {
      return $::env($name)
    }
    if {[llength $args]} {
      return [lindex $args 0]
    }
    return -code error "environment variable \"$name\" does not exist"
  }
  
  ###
  # topic: 7061a69eeff782ec0c30dcc18ccfca91b04b7371
  ###
  method is_tty channel {
    dict exists [fconfigure $channel] -xchar
  }

  ###
  # For unix, we don't have to worry about volumes
  ###
  method path-msys path {
    return $path
  }

  method path-msys-relative {base filename} {
    set base [my path-msys $base]
    set filename [my path-msys $filename]
    return [::fileutil::relative $base $filename]
  }

  method path-real path {
    return $path
  }

  ###
  # topic: 69630150a734cce14ef3b54abd79dcb779ca7766
  # description: unix separates $PATH with colons and has and executable bit
  ###
  method search_path {} {
    split [my getenv PATH .] {:}
  }

  method user_home {} {
    if {[info exists ::env(HOME)]} {
      if {[file exists $::env(HOME)]} {
        return $::env(HOME)
      }
    }
    catch {
      set ::env(HOME) [file normalize ~]
    }
    if {[info exists ::env(HOME)]} {
      if {[file exists $::env(HOME)]} {
        return $::env(HOME)
      }
    }
    set ::env(HOME) [::fileutil::tempdir]
    catch {
      file mkdir $::env(HOME)
    }
    return $::env(HOME)
  }

  ###
  # topic: eb8a738d9222065f206b21654f52490082be2a11
  ###
  method user_data_root appname {
    return [file join $::env(HOME) .$appname]
  }
  
  method as_teapot_location {} {
    return /opt/local/ActiveTcl8.6/teapot
  }
}








