###
# The base object for localtool is based loosely on the structures used in
# autosetup
###

###
# topic: f46f688e26b3d6d6386eb4a777ea14162d7733f2
###
gort::class create ::gort::platform.meta {

  arrayobj teapot   teapot {
    platform {
      if {[llength $args]==0} {
        return [my _teapotGet platform]
      }
    }
  }
  arrayobj binary   binary
  arrayobj platform platform {
    platform { return [my _teapotGet platform] }
  }
  arrayobj tcl      tcl
  arrayobj tk       tk
  
  ###
  # topic: 8dad77504fb51914d9717bb979dc1c08a2882638
  ###
  method check-feature {name code} {
    set r [uplevel 1 $code]
    my define set [my define-feature-name $name] $r
    return $r
  }

  ###
  # topic: a6dd101b36dcc1644c4ab4bed596507ef5a0ed67
  # description: Note that the return code is not meaningful
  ###
  method check-something {name code} {
    uplevel 1 $code
  }

  ###
  # topic: eb5ab66540987da0361cb51da524402411d47f73
  ###
  method configlog args {
    if {$::autosetup(debug)} {
      puts "CONF: $args"
    }
  }

  ###
  # topic: ce5dff2fe2b1430ac26fea5b3fa90f418e22fb19
  ###
  method define-add {name args} {
    my variable define
    if {![info exists define($name)]} {
      set define($name) {}
    }
    foreach item $args {
      if {item ni $define(name)} {
        lappend define(name) $item
      }
    }
  }

  ###
  # topic: c56ea85311b1aef5f1153ce201e083ec5046bc9d
  ###
  method define-all {} {
    my variable define
    return [array get define]
  }

  ###
  # topic: 31261c9c578d36bf9b480f202c15035b4a804af0
  ###
  method define-exists name {
    my define set exists $name
  }

  ###
  # topic: a2295b998d7cfe1be6b2b9c2a2504633b436506a
  ###
  method define-feature {name {value 1}} {
    my define set [my define-feature-name $name] $value
  }

  ###
  # topic: d298dfb731ed9d6cccb8a2797ddc374f1b9c44ba
  ###
  method define-feature-name {name {prefix HAVE_}} {
    string toupper $prefix[regsub -all {[^a-zA-Z0-9]} [regsub -all {[*]} $name p] _]
  }

  ###
  # topic: 0d6d52b8ccd575685868449ceb97afd21d754797
  # description:
  #    @define-get name ?default=0?
  #    
  #    Returns the current value of the 'defined' variable, or $default
  #    if not set.
  ###
  method define-get {name {default 0}} {
    my variable define
    if {[info exists define($name)]} {
      return $define($name)
    }
    return $default
  }

  ###
  # topic: 331d4104f4a5dfc85d7e3ad36347cfd9245a28b2
  # description:
  #    @env-is-set name
  #    
  #    Returns 1 if the $name was specified on the command line or in the environment.
  #    Note that an empty environment variable is not considered to be set.
  ###
  method env-is-set name {
    my variable config
    if {[info exists config] && [dict exist $config $name]} {
      return 1
    }
    if {[my getenv $name ""] ne ""} {
      return 1
    }
    return 0
  }

  ###
  # topic: 9d50011f9bf68159f67bdc5b185b1004f993156b
  ###
  method feature-checked name {
    my define set exists [my define-feature-name $name]
  }

  ###
  # topic: a52ceef250393f665f101441abc81c2385465478
  # description:
  #    @get-env name default
  #    
  #    If $name was specified on the command line, return it.
  #    If $name was set in the environment, return it.
  #    Otherwise return $default.
  ###
  method get-env {name default} {
    if {[my define exists $name]} {
      return [my define cget $name]
    }
    my getenv $name $default
  }

  ###
  # topic: 25318843e29ab716ab9098ce10fdc0f7ae6ac8b0
  ###
  method getenv {name args} {
    if {[info exists ::env($name)]} {
      return $::env($name)
    }
    if {[llength $args]} {
      return [lindex $args 0]
    }
    return -code error "environment variable \"$name\" does not exist"
  }
  ###
  # topic: 1be6ad25fd3e2f5fb9ad1207407e5c3bdf6fc9e1
  ###
  method have-feature {name {default 0}} {
    set dname [my define-feature-name $name]
    if {[my define exists $dname]} {
      return [my define get $dname]
    }
    return $default
  }

  
  ###
  # topic: d4b3fff74f9af8c2b4d5ecc5b5733b063be324da
  ###
  method msg-checking msg {
    if {$::autosetup(debug)} {
      puts "MSG: $msg"
    }
  }

  ###
  # topic: dfd9af33a53760d6f9a5f0e4df58d2bdb52782f0
  ###
  method msg-quiet args {}

  ###
  # topic: 9334ae978f4ecb297ac447338a290e050276e060
  ###
  method msg-result msg {
    if {$::autosetup(debug)} {
      puts "MSG: $msg"
    }
  }
  
  ###
  # topic: 3a26f026e23977bff36e1594051ef61b018ffb26
  # description:
  #    @prefix pre list
  #    
  #    Takes a list and returns a new list with $pre prepended
  #    to each element
  #    
  #    prefix jim- {a.c b.c} => {jim-a.c jim-b.c}
  ###
  method prefix {pre list} {
    set result {}
    foreach p $list {
      lappend result $pre$p
    }
    return $result
  }

  ###
  # topic: 93cd1c654b326e4360a9c85cdd65d2069ffcb389
  ###
  method quote-argv argv {
    set args {}
    foreach arg $argv {
      lappend args [my quote-if-needed $arg]
    }
    join $args
  }

  ###
  # topic: 86e3d2e8fd50eec41771cca4995ddb43d2879b39
  ###
  method quote-if-needed str {
    if {[string match {*[\" ]*} $str]} {
      return \"[string map [list \" \\" \\ \\\\] $str]\"
    }
    return $str
  }

  ###
  # topic: aef94cd060c7a8b8f00b396284b1e093fa04d7fe
  # description:
  #    @readfile filename ?default=""?
  #    
  #    Return the contents of the file, without the trailing newline.
  #    If the doesn't exist or can't be read, returns $default.
  ###
  method readfile {filename {default_value ""}} {
    set result $default_value
    catch {
      set f [open $filename]
      set result [read -nonewline $f]
      close $f
    }
    return $result
  }

  ###
  # topic: 0eeb74b7c417cc3569b68c922ed25720ec45fd74
  # description:
  #    @suffix suf list
  #    
  #    Takes a list and returns a new list with $suf appended
  #    to each element
  #    
  #    suffix .c {a b c} => {a.c b.c c.c}
  ###
  method suffix {suf list} {
    set result {}
    foreach p $list {
      lappend result $p$suf
    }
    return $result
  }
  
  method tcl-shlib-name {package version} {
    return lib${package}${version}[info sharedlibextension]
  }
  
  ###
  # topic: efbdeb3d7241c963d36c7825a7eb88da7dca8aab
  # description:
  #    If $file doesn't exist, or it's contents are different than $buf,
  #    the file is written and $script is executed.
  #    Otherwise a "file is unchanged" message is displayed.
  ###
  method write-if-changed {file buf {script {}}} {
    set old [my readfile $file ""]
    if {$old eq $buf && [file exists $file]} {
      my msg-result "$file is unchanged"
    } else {
      my writefile $file $buf\n
      uplevel 1 $script
    }
  }

  ###
  # topic: e4d97be0f731246a3bdb4bce810bfef1bf9b06f6
  # description:
  #    @writefile filename value
  #    
  #    Creates the given file containing $value.
  #    Does not add an extra newline.
  ###
  method writefile {filename value} {
    set f [open $filename w]
    puts -nonewline $f $value
    close $f
  }
}

###
# Tool to ensure we always produce the right canonical
# teapot name
###
proc ::gort::platform_normalize target {
  switch $target {
    windows {
      return win32-x86_64
    }
    macosx {
      return macosx10.5-i386-x86_64
    }
    linux {
      return linux-glibc2.3-x86_64
    }
  }
  return $target
}