package require fileutil
package require md5
package require tool
set ::autosetup(debug) 0

set here [file dirname [file normalize [info script]]]
::namespace eval ::gort {}
set ::gort::home $here
foreach file {
  metaclass.tcl
  db.tcl
  utils.tcl
} {
  source [file join $here $file]
}

foreach file {
  core.tcl
  platform.tcl
  platform_unix.tcl
  platform_unix_linux.tcl
  platform_unix_macosx.tcl
  platform_windows.tcl
} {
  source [file join $here platform $file]
}

foreach file {
  distribution_core.tcl
  distribution_snapshot.tcl
  distribution_teapot.tcl
  distribution_fossil.tcl
  distribution_git.tcl
  distribution_subversion.tcl
} {
  source [file join $here distribution $file]
}

foreach file {
  toolset_core.tcl
  toolset_make.tcl
  toolset_autoconf.tcl
  toolset_autosetup.tcl
  toolset_cmake.tcl
  toolset_tcl.tcl
} {
  source [file join $here toolset $file]
}

foreach file {
  recipe_core.tcl
  recipe_package.tcl
  recipe_teapot.tcl
  recipe_tea.tcl
  recipe_sak.tcl
  recipe_odie.tcl
  recipe_virtual.tcl
  recipe_tclcore.tcl
} {
  source [file join $here recipe $file]
}


set genus [lindex [split [::platform::generic] -] 0]
dict set ::gort::platform tcl_os       $::tcl_platform(os)
dict set ::gort::platform odie_class   $::tcl_platform(platform)
dict set ::gort::platform odie_genus   $genus
dict set ::gort::platform odie_target  [::platform::generic]
dict set ::gort::platform odie_species [::platform::identify]

###
# Build an object called "localtool"
###
::gort::platform create ::localtool
::localtool localize

package provide gort 0.1