###
# topic: 216b4a8e9bc92bb89eef692f7d4352dfd87a7c53
###
gort::class create ::gort::distribution.snapshot {
  superclass gort::distribution

  property snapshot_dir {}
  property snapshot_url {}

  self method match info {
    if {[dict exists $info snapshot_url]} {
      return 1
    }
    # Fossil can export zip files
    if {[dict exists $info fossil_url]} {
      return 1
    }
    # Git can export zip files
    if {[dict exists $info git_url]} {
      return 1
    }
    return 0
  }

  ###
  # topic: 3b3ec6daffc73ab56e4058689e0c50796825d5c2
  ###
  method download {path} {
    if {[file exists [file join $path gort.download]]} {
      return
    }
    set snapshot [my snapshot_file]
    if {![file exists $snapshot]} {
      package require http::wget
      file mkdir [file dirname $snapshot]
      ::http::wget [my snapshot_url] $snapshot
    }
    my unpack $snapshot $path
    set fout [open [file join $path gort.download] w]
    puts $fout "Unpacked: [clock format [clock seconds]]"
    puts $fout "Url: [my snapshot_url]"
    close $fout
  }

  ###
  # topic: 2124e3bee6f61bd31e02822a275ca5e148dd60e4
  ###
  method teapot_data {} {
    set buffer {}
    append buffer \n [list Meta as::origin [my define getnull snapshot_url]]
    return $buffer
  }

  ###
  # topic: b6fc7a790affd0b07a7f26402d407baf24dd42df
  ###
  method snapshot_file {} {
    if {[my define exists snapshot_url]} {
      set url [my snapshot_url]
      set fname [file tail $url]
      return [file join $::gort(download) source $fname]
    }
    if {[my define exists fossil_url]} {
      set modname [my define cget module_name]
      set tag [my meta getnull fossil_tag]
      if {$tag eq {}} {
        set tag trunk
      }
      return [file join $::gort(download) source $modname-$tag.zip]
    }
    if {[my define exists git_url]} {
      set modname [my define cget module_name]
      set tag [my meta getnull git_branch]
      if {$tag in {{} HEAD trunk master}} {
        set tag master
      }
      return [file join $::gort(download) source $modname-$tag.zip]
    }
    error "Could not compute a filename for snapshot"
  }

  ###
  # topic: 3083c59ef82fb84ba25cde48280308276e36d3e9
  ###
  method snapshot_url {} {
    if {[my define exists snapshot_url]} {
      return [my define getnull snapshot_url]
    }
    if {[my define exists fossil_url]} {
      set modname [my define cget module_name]
      set url [my define getnull fossil_url]
      set tag [my define getnull fossil_tag]
      if {$tag eq {}} {
        set tag trunk
      }
      set url "$url/zip/$modname-$tag.zip?uuid=$tag"
      return $url
    }
    if {[my define exists git_url]} {
      set modname [my define cget module_name]
      set url [my define getnull git_url]
      set tag [my define getnull git_branch]
      if {$tag in {{} HEAD trunk master}} {
        set tag master
      }
      set url "$url/archive/$tag.zip"
      return $url
    }
    error "Could not determine a URL for the snapshot"
  }

  ###
  # topic: ba1263b326d38a91ce5b4e507800dcce0e7659ae
  ###
  method unpack {archive destination} {
    switch [string tolower [file extension $archive]] {
      .zip {
        ::command::archive::unzip $archive $destination
      }
      .tgz {
        ::command::archive::untar $archive $destination
      }
      .gz {
        if {[file extension [file rootname $archive]] != ".tar"} {
          error "Unknown file type for [file tail $archive"
        }
        ::command::archive::untar $archive $destination
      }
    }
  }
}

