###
# topic: 485f97e1b374093a69582392ef723911d0240eba
###
gort::class create ::gort::distribution/git {
  superclass gort::distribution.snapshot

  property git_url {}
  property git_branch HEAD
  
  self method match info {
    if {$::gort(git) eq {} } {
      return 0
    }
    if {[dict exists $info git_url]} {
      return 1
    }
    return 0
  }
  
  ###
  # topic: 7bbbf0ae38c01c191bae78ab2b65f562ba42f1ba
  ###
  method download {path} {
    if {[file exists $path]} return
    if {![file exists $::gort(sandbox)]} {
      file mkdir $::gort(sandbox)
    }
    if {[file exists $path.git]} return
    cd $::gort(sandbox)
    set tag [my define getnull git_branch]
    if {$tag in {{} HEAD trunk master}} {
      set tag master
    }
    set branch $tag
    if {$branch eq "master"} {
      doexec $::gort(git) clone {*}[my define getnull git_url] [my define getnull module_name]       
    } else {
      doexec $::gort(git) clone -b $branch {*}[my define getnull git_url] [my define getnull module_name]
    }
  }

  ###
  # topic: 70106bc439c56c6bd4f9f0e27b611928b20b93cf
  ###
  method detect-metadata {path} {
    if {![file exists $path]} {
      return {}
    }
    set result {}
    cd $path
    set dat [doexec $::gort(git) status]
    foreach line [split $dat \n] {
      if {[lindex $line 0] eq "tags:"} {
        dict set result tags [string trim [lrange $line 1 end]]
        break
      }
      if {[lindex $line 0] eq "checkout:"} {
        set hash [lindex $line end-3]
        set maxdate [lrange $line end-2 end-1]
        dict set result checkout $hash
        dict set result datestamp $maxdate
      }
      if {[lindex $line 0] eq "comment:"} {
        break
      }
    }
    return $result
  }

  ###
  # topic: df033c8a19b0833d7965216d7a73ea4632b87d8b
  ###
  method teapot_data {} {
    set buffer {}
    append buffer \n [list Meta as::origin [my define getnull git_url]]
    return $buffer
  }

  ###
  # topic: a35d103c6b0df23a10b325c0b5d887d70e2922f9
  ###
  method upgrade {path} {
    if {$::gort(git) eq {} } {
      return 0
    }
    cd $path
    set mod [my define getnull module_name]
    set dat [::gort::meta_get $mod]

    if {![dict exists $dat url] || [dict get $dat url] != [my define getnull git_url]} {
      catch {doexec $::gort(git) pull [my define getnull git_url]} dat
    } else {
      catch {doexec $::gort(git) pull} dat
    }
    set info [my detect-metadata $path]
    if {[dict exists $dat checkout]} {
      if {[dict get $info checkout] == [dict get $dat checkout]} {
        return 0
      }
    }
    return 1
  }

  ###
  # topic: 440309dc33cc326cace1707dc841fcdfb74c91f1
  ###
  method git_branch {} {
    set tag [my define getnull git_branch]
    if {$tag in {{} HEAD trunk master}} {
      return master
    }
    return $tag
  }
}

