###
# topic: 396d8a88f52c69d007e8d2af02fc99504c6d193f
###
gort::class create ::gort::distribution/fossil {
  superclass gort::distribution.snapshot

  property fossil_url {}
  property fossil_tag trunk

  self method match info {
    if {$::gort(fossil) eq {} } {
      return 0
    }
    if {[dict exists $info fossil_url]} {
      return 1
    }
    return 0
  }

  ###
  # topic: 4f752eae6bf61e3d7adbe1e8f458b22ffcf0291b
  ###
  method download {path} {
    if {[file exists ${path}]} return
    file mkdir [file join $::gort(download) fossil]
    if {![file exists [my fossil_db]]} {     
      cd $::gort(download)
      ::command::fossil clone [my define getnull fossil_url] [my fossil_db]
    }
    file mkdir $path
    cd $path
    if {![file exists [file join $path-module _FOSSIL_]] && ![file exists [file join $path-module .fslckout]]} {
      ::command::fossil open [my fossil_db] [my define getnull fossil_tag]
    } else {
      ::command::fossil update [my define getnull fossil_tag]
    }
  }

  ###
  # topic: 27bec120002436a8b25391151e7aba5c6de2d763
  ###
  method detect-metadata {path} {
    if {$::gort(fossil) eq {} } {
      # If we have no fossil binary, behave like a snapshot
      return [next]
    }
    set result {}
    if {![file exists $path]} {
      return [next]
    }
    set cwd [pwd]
    cd $path
    dict set result url [my define getnull fossil_url]
    if {![file exists [::localtool platform get fossil_checkout]]} {
      return {}
    }
    set dat [exec $::gort(fossil) status]
    foreach line [split $dat \n] {
      if {[lindex $line 0] eq "tags:"} {
        dict set result tags [string trim [lrange $line 1 end]]
        break
      }
      if {[lindex $line 0] eq "checkout:"} {
        set hash [lindex $line end-3]
        set maxdate [lrange $line end-2 end-1]
        dict set result checkout $hash
        dict set result datestamp $maxdate
      }
      if {[lindex $line 0] eq "comment:"} {
        break
      }
    }
    cd $cwd
    return $result
  }

  ###
  # topic: 44b0f62945f2362a3c29d044cdac7757ed2cb9c3
  ###
  method teapot_data {} {
    set buffer {}
    append buffer \n [list Meta as::origin [my define getnull fossil_url]]
    return $buffer
  }

  ###
  # topic: 1354aae976c10d55f156cecb2d40d65c24ddea2e
  ###
  method upgrade path {
    set mod [my define getnull module_name]
    set dat [::gort::meta_get $mod]
    set reregister 0
    if {![file exists $path]} {
      return 1
    }
    cd [my path-module]
    if {![dict exists $dat url] || [dict get $dat url] != [my define getnull fossil_url]} {
      catch {doexec $::gort(fossil) pull [my define getnull fossil_url]}
    }
    catch {doexec $::gort(fossil) update [my define getnull fossil_tag]}
    set info [my detect-metadata $path]
    if {[dict exists $dat checkout]} {
      if {[dict get $info checkout] == [dict get $dat checkout]} {
        return 0
      }
    }
    return 1
  }

  ###
  # topic: ea66cd060e6f92f5e509d1417aeda3dcc030779e
  ###
  method fossil_db {} {
    set modname [my define getnull module_name]
    foreach ext {.fossil .fos} {
      set fname  [file join $::gort(download) $modname$ext]
      if {[file exists $fname]} {
        return $fname
      }
      set fname  [file join $::gort(download) fossil $modname$ext]
      if {[file exists $fname]} {
        return $fname
      }
    }
    return $fname
  }

  ###
  # topic: 64f89721f2aff74542333439277cb2d59121a25d
  ###
  method snapshot_url {} {
    set url [string trimright [my define getnull fossil_url] /]
    set tag [my define getnull fossil_tag]

    append url /zip/[my package_name]-$tag.zip?uuid=$tag
    return $url
  }
}

