###
# Classes used for building
###

::namespace eval ::oo::define {}
::namespace eval ::recipe {}
::namespace eval ::recipe::class {}
::namespace eval ::recipe::object {}

::namespace eval ::gort {}
::namespace eval ::gort {}

###
# topic: df51ef366543151489f642cb64862f49316d1728
# description: GNDN
###
proc ::oo::define::aliases args {}

###
# topic: 6e87c8e49197de1995f2c541233ae6ccd4107420
###
proc ::gort::load_recipes path {
  if {$path eq {}} {
    set path [file join $::gort(home) recipes]
  }
  set ::gort::recipes $path
  uplevel #0 {
  proc ::gort::metapath {} [list return $::gort(metapath)]

  #::tao::load_path [file join $::gort(home) recipes] {basic.tcl}
  puts "LOADING RECIPES FROM $::gort::recipes"
  ::tool::pathload $::gort::recipes {basic.tcl}

  if {[file exists [file join $::gort(settings) gort.rc]]} {
    source [file join $::gort(settings) gort.rc]
  }
  # For now... ignore the teapot
  #::gort::load_teapot
  variable info
  set order {}
  set sorted {}
  set allmod [lsort -dictionary [array names info]]
  while 1 {
    set done 1
    foreach {mod info} [lsort -stride 2 [array get info]] {
      if { $mod in $order } continue
      set after [dict getnull $info compile_after]
      if {$after eq {}} {
        lappend order $mod
      } else {
        set idx [lsearch $allmod $after]
        if { $idx < 0} {
          error "$mod requested to be after $after, which wasn't registered in $allmod"
        }
        set idx [lsearch $order $after]
        if { $idx < 0 } {
          set done 0
        } else {
          set order [linsert $order [expr {$idx+1}] $mod]
        }
      }
    }
    if {$done} break
  }
  
  proc ::gort::recipe_order {} [list return $order]
  
  ::gort::read_manifest
}
}

###
# topic: 00b601f4106d208dde1074e29233c7ed878772ec
# title: Build/Restore modules from teapot
###
proc ::gort::load_teapot {} {
  set tpidx [file join $::gort(metapath) teapot.rc]
  
  if {[file exists $tpidx]} {
    if {([clock seconds] - [file mtime $tpidx]) > 86400} {
      file rename -force $tpidx $tpidx.bak
    }
  }
  if {[file exists $tpidx]} {
    source $tpidx
    return
  }
  file mkdir $::gort(metapath)
  set fout [open $tpidx w]

  package require gort::teapot
  if {$::tcl_platform(platform) == "unix"} {
    set os [string tolower $::tcl_platform(os)]
  } else {
    set os [string tolower $::tcl_platform(platform)]
  }
  set cpu [string tolower $::tcl_platform(machine)]
  puts $fout "###
# TEAPOT PACKAGE MANIFEST FOR
# OS: $os
# CPU: $cpu
###"

  set loaded 0
  foreach teapotserver $::teapotservers {
    catch {
    foreach {ext extinfo} [::teapotclient::get_extensions $teapotserver $os $cpu -1] {
      foreach {version target} $extinfo {
        lappend exts($ext) [list $version $target $teapotserver]
      }
      incr loaded
    }
    }
  }
  if {$loaded} {
    foreach ext [lsort -dictionary [array names exts]] {
      set extinfo $exts($ext)
    
      set extvers [list]
      foreach extinfoitem $extinfo {
        set extinfoitemvers [lindex $extinfoitem 0]
        if {[lsearch -exact $extvers $extinfoitemvers] == -1} {
          lappend extvers $extinfoitemvers
        }
      }
      set extvers [lsort -decreasing -dictionary $extvers]
      set verdat [lindex $extvers 0]
      set pkgvrs [lindex $verdat 0]
      set pkgplat [lindex $verdat 1]
      puts $fout [list ::gort::recipe_define $ext [list package_name $ext package_version $pkgvrs package_platform $pkgplat distribution teapot toolset teapot]]
    }
    close $fout
  } else {
    if {[file exists $tpidx.bak]} {
      file rename -force $tpidx.bak $tpidx
    }
  }
  source $tpidx
}

###
# topic: b412ec0912ddb2c0a0a84b4e3dd87faa6667b835
###
proc ::gort::recipe_define {name properties {definition {}}} {

  set name [string tolower $name]
  dict set properties module_name $name
  variable info
  variable cname
  variable group
  dict set properties oo_define $definition
  set info($name) $properties  
  set cname($name) $name
  foreach alias [dict getnull $properties aliases] {
    set cname($alias) $name
  }
  foreach group [dict getnull $properties group] {
    lappend group($group) $name
  }
}

###
# topic: 0405be1f5b62823c024e36117d8fef830cdad977
###
proc ::gort::recipe_teapot {name properties} {
  ###
  # A gort defined version exists... ignore
  ###
  if {[info exists ::recipe($name)]} return

  # Create an instance of this class
  set object [::gort::recipe.teapot create ::recipe::$name $properties]
  set ::recipe($name) ::recipe::$name
  foreach alias [dict getnull $properties aliases] {
    set ::recipe($alias) ::recipe::$name
  }
  foreach group [dict getnull $properties group] {
    lappend ::recipe_group($group) $name
  }
  return $object
}

proc ::gort::recipe_group {name list} {
  set ::recipe_group($name) $list
}

proc ::gort::recipe_object {name args} {
  variable cname
  if {![info exists cname([string tolower $name])]} {
    error "Unknown recipe $name"
  }
  set name $cname([string tolower $name])
  set objname ::recipe::object::$name
  if {[info commands $objname] ne {}} {
    return $objname
  }
  variable info
  ::gort::recipe create $objname $info($name)
  return $objname
}

if {[catch {package require sqlite3} err]} {
###
# Version of meta tools to run with no working sqlite
###
proc ::gort::meta_get {package args} {
  variable metadata
  if {![dict exists $metadata $package]} {
    return {}
  }
  if {[llength $args] eq 0} {
    return [dict get $metadata $package]
  }
  set result {}
  foreach field $args {
    if {[dict exists $metadata $package $field]} {
      lappend result [dict get $metadata $package $field]
    } else {
      lappend result {}
    }
  }
  return $result
}

proc ::gort::meta_clear {package} {
  variable metadata
  dict set metadata $package {}
  meta_signal $package
}

proc ::gort::meta_put {package field value} {
  variable metadata
  dict set metadata $package $field $value
  meta_signal $package
}

proc ::gort::meta_signal {package} {
  variable nextevent
  after cancel $nextevent
  set nextevent [after idle ::gort::meta_backup]
  variable package_updates
  lappend package_updates $package
}

proc ::gort::meta_backup {} {
  variable package_updates
  variable metadata
  set path $::gort(metapath)
  file mkdir $path
  foreach package $package_updates {
    set fout [open $path/$package.txt w]
    puts $fout "# Manifest of data for package $package"
    foreach {field value} [dict get $metadata $package] {
      puts $fout [list $field $value]
    }
    close $fout
  }
  set package_updates {}
}

proc ::gort::read_manifest {} {
  variable metadata
  set path $::gort(metapath)
  foreach file [glob -nocomplain $path/*.txt] {
    set fin [open $file r]
    set package [file rootname [file tail $file]]
    while {[gets $fin line] >= 0} {
      if {[string index [string trim $line] 0] eq "#"} continue
      set field [lindex $line 0]
      set value [lindex $line 1]
      dict set metadata $package $field $value
    }
    close $fin
  }
}

} else {
  
proc ::gort::meta_clear {package} {
  metadb eval {delete from module_info where package=:package}
  meta_signal $package
}
  
proc ::gort::meta_get {package args} {
  if {[llength $args] eq 0} {
    return [metadb eval {select field,value from module_info where package=:package}]
  }
  set result {}
  foreach field $args {
    lappend result [metadb one {select value from module_info where package=:package and field=:field}]
  }
  return $result
}

proc ::gort::meta_put {package field value} {
  metadb eval {insert or replace into module_info
(package,field,value) VALUES (:package,:field,:value)}
  meta_signal $package
}

proc ::gort::meta_signal {package} {
  variable nextevent
  after cancel $nextevent
  set nextevent [after idle ::gort::meta_backup]
  variable package_updates
  lappend package_updates $package
}

proc ::gort::meta_backup {} {
  variable package_updates
  set path $::gort(metapath)
  file mkdir $path
  foreach package $package_updates {
    set fout [open $path/$package.txt w]
    puts $fout "# Manifest of data for package $package"
    metadb eval {select field,value from module_info where package=:package order by field} {
      puts $fout [list $field $value]
    }
    close $fout
  }
  set package_updates {}
}

proc ::gort::read_manifest {} {
  set path $::gort(metapath)
  if {![file exists $path]} {
    file mkdir $path
  }
  set idxfile [file join $path gort.sqlite]
  if {![file exists $idxfile]} {
    sqlite3 metadb $idxfile
    metadb eval {
create table module_info (
  package string,
  field   string,
  value   string,
  primary key (package,field) on conflict replace
);
insert into module_info (package,field,value) VALUES
('gort','schema','0.1');
    }
    foreach file [glob -nocomplain [file join $path *.txt]] {
      set fin [open $file r]
      set package [file rootname [file tail $file]]
      while {[gets $fin line] >= 0} {
        if {[string index [string trim $line] 0] eq "#"} continue
        set field [lindex $line 0]
        set value [lindex $line 1]
        metadb eval {
insert into module_info (package,field,value) VALUES (:package,:field,:value);
        }
      }
      close $fin
    }
  } else {
    sqlite3 metadb $idxfile
  }
}
}

###
# Provide backward compadible aliases
###

set ::gort::nextevent {}
set ::gort::metadata {}
