#! /bin/sh
# The next line is executed by /bin/sh, but not tcl \
exec tclsh $0 ${1+"$@"}

###
# Load configuration
###
set here [file dirname [file normalize [info script]]]
namespace eval ::gort {}

set ::gort(tclsh) [info nameofexecutable]
set ::gort(main)  [file normalize [info script]]
set ::gort(self-contained)  0
set ::gort(exec)  [list $::gort(tclsh) $::gort(main)]
set ::gort(home)  $here
set ::gort(modules) [file join $::gort(home) modules]

set ::SRCDIR [file join $::gort(home) src]
namespace eval ::starkit {
  set topdir $::SRCDIR
}

source $::SRCDIR/../scripts/bootstrap.tcl
 
# Inject gort's versions of things ahead of anything in the environment
set ::auto_path [linsert $::auto_path 0 $::gort(modules)] 
source $::SRCDIR/shell.tcl
