package provide temple::server::h 0.1

package require Debug	;# provides debugging narrative
package require Direct	;# provides Direct domain - namespace/TclOO command access via URL
package require File	;# provides File domain - deliver content of file system via URL
package require H	;# provides the H HTTP server itself

Debug on error		;# we always want to see errors
# we don't so much care about these other debug narratives
Debug define query
Debug off file
Debug off direct
Debug off process

Debug off httpd
Debug off listener
Debug off httpdlow
Debug off httpdtx
Debug off httpdtxlow
Debug off entity
Debug off cache
Debug off cookies

# Create some File domains - these are invoked by the dispatcher below
# Each of these is an object which interprets requests over the file-system
File create home root $::H::home	;# this is the directory Sandbox is running in
File create user root [pwd]	;# this is the directory the user ran Sandbox from
File create css root [file join $::H::home css]

# dispatcher - this is the thing which determines where and how requests are processed
# dispatcher is an instance of the Direct object, it interprets HTTP requests as
# Tcl command invocations (with arguments.)
Direct create dispatcher {
    method /home {r} {
	return [home do $r]
    }
    method /css {r} {
	return [css do $r]
    }
    method /user {r} {
	return [user do $r]
    }

    method / {r} {
      set fossil ""
      foreach path [dict keys $::fossil_server] {
        append fossil \n <li> "<a href='/${path}'>/$path</a>" </li> \n
      }
      return [H Ok $r content-type text/html [subst $::toplevel]]
    }

    method /favicon {r} {
	return [H NotFound $r]	;# we don't have an icon
    }
    
    method /fossil {r} {
      set fossil ""
      foreach path [dict keys $::fossil_server] {
        append fossil \n "<li>/$path</li><ul>"
        foreach {repo info} [dict get $::fossil_server $path] {
          dict with info {}
          append fossil \n <li> "<a href='${siteurl:}'>$repo</a>" </li> \n
        }
      }
      set template {
<html>
    <head>
    </head>
    <body>
    <p>Here are the fossil repositories containing this instance.</p>
    <ul>$fossil</ul>
    </body>
</html>
      }
      return [H Ok $r content-type text/html [subst $template]]
    }
    
    method |fossil r {
      lassign [split [dict get $r -Full]] method uri version
      set fn [lindex [split $uri /] 2]
      set uri [join [lrange [split $uri /] 3 end] /]
      if { $fn eq {} } {
        return [list $r {} {}]
      }
      return [list $r [socket localhost [dict get $::fossil_server fossil $fn port:]] /$uri]
    }
}

# process command line arguments when this script is called from the command line
# process command line args
set root $::H::home	;# by default this is where the server will look for files


# start the H server's listener
set largs {}
lappend largs rxprocess ::Identity	;# H will not pre-process requests (permits passthru)
lappend largs dispatch {dispatcher do}	;# H will dispatch requests to $dispatch for processing
lappend largs tls {} 
#lappend largs tls [list -require 0 -certfile server.crt -keyfile server.key -cadir $::H::home]	;# for TLS - certs in $home
set ::listener [H listen {*}$largs [dict get $::httpd server port:]]
puts stderr "H listening on port [dict get $::httpd server port:]"

