#! /bin/sh
# The next line is executed by /bin/sh, but not tcl \
exec tclsh $0 ${1+"$@"}

###
# Load configuration
###
set appname [lindex $argv 0]


# toplevel is a template generating the html for the top level page
variable toplevel {
<html>
    <head>
    </head>
    <body>
    <p>Here are the fossil repositories containing this instance.</p>
    <ul>$fossil</ul>
    </body>
</html>
}

package require gort::settings

dict set ::httpd server port: 8080	;# this is the port on which the server will listen
dict set ::httpd server name: [info hostname]
dict set ::httpd db filename: [file join $::gort(metapath) var temple temple.sqlite]
dict set ::httpd server engine: h
dict set ::httpd fossil fossil path: $::gort(download)
###
# Load the persistant config file
###
if {[file exists [file join $::gort(metapath) temple.rc]]} {
  source [file join $::gort(metapath) temple.rc]
}

foreach {var val} $argv {
  switch $var {
    configfile {
      source $val
    }
    default {
      dict set ::httpd server ${var}: $val
    }
  }
}

source $SRCDIR/server/[dict get $::httpd server engine:].tcl
source $SRCDIR/modules/fossil.tcl
source $SRCDIR/modules/teapot.tcl
source $SRCDIR/modules/dbstore.tcl

###
# Index our fossil repos
###
foreach {fosgroup conf} [dict get $::httpd fossil] {
  dict with conf {}
  foreach f [glob -directory ${path:} -nocomplain -types f -- *.fossil] {
    fossil_host $fosgroup $f
  }
  foreach f [glob -directory ${path:} -nocomplain -types f -- *.fos] {
    fossil_host $fosgroup $f
  }
}
::vwait forever

