#!/usr/bin/env tclsh

## CTHULHU. Provides a bevy of useful templating functions for building
## C extensions from Tcl for Tcl. Oh yes... and it implements a poor man's
## Cmake using Tcl notation

## Setok's Make. Provides similar functionality as 'make' but with TCL
## scripts as makefiles. This allows for a building process which is much
## more versatile that what is available with the normal make. In addition,
## because of the nature of Tcl, the actual workings of smake itself can be 
## dynamically replaced as needed.
##
## Authors: Kristoffer Lawson, setok@fishpool.com


lappend auto_path [file dirname [info script]]
set NoDebug 0  ;# Empty debug procs
package require cthulhu 2.0

## Default rule to handle targets which aren't explicitly defined.

setRule * $DefStarRule

# ##### #
# Main  #
# ##### #

set Verbose false
set Smakefile Smakefile
set argv [parse_opt $argc $argv]
if {[llength $argv] > 0} {
    set target [lindex $argv 0]
} else {
    set target all
}

if {! $Verbose} {
    rename error error_old
    rename errorMsg error

    set errcode [catch {
	set BUILDPATH [pwd]
	source $Smakefile
	depend $target {}
    } errmsg ]
    
    if {$errcode == $TCL_ERROR} {
	error $errmsg
    }
} else {
    source $Smakefile
    depend $target {}
}
