package require Tk
package require taotk

tao::class create gort_console {
  superclass taotk::meta::console taotk::toplevel

  constructor {window args} {
    my InitializePublic
    my Hull_Build $window {} {*}$args
  }
  
  meta branchset option prompt {
    default: {gort% }
  }
  
  ###
  # topic: c3d3bed792724df80d4ee0a5b1bc486d2501fd69
  # description:
  #    Called when "Enter" is pressed.  Do something with the line
  #    of text that was entered.
  ###
  method Enter {} {
    my variable v
    set w [my organ text]
    scan [my <text> index insert] %d.%d row col
    set start $row.$v(plength)
    set line [my <text> get $start "$start lineend"]
    my addHistory $line
    my <text> insert end \n
    my <text> mark set out end
    if {$v(prior)==""} {
      set cmd $line
    } else {
      set cmd $v(prior)\n$line
    }
    if {[info complete $cmd]} {
      set v(tag) ok
      set rc [catch {my Evaluate $cmd} res]
      if {![winfo exists $w]} return
      if {$rc} {
        my <text> insert end $res\n err
      } elseif {[string length $res]>0} {
        my <text> insert end $res\n $v(tag)
      }
      set v(prior) {}
      my <text> insert end $v(prompt)
    } else {
      set v(prior) $cmd
      regsub -all {[^ ]} $v(prompt) . x
      my <text> insert end $x
    }
    my <text> mark set insert end
    my <text> mark set out {insert linestart}
    my <text> yview insert
  }
  
  method Evaluate cmd {
    my puts $cmd green
  }

  method coroutine_start args {
    ::catch {rename [namespace current]::coroutine {}}
    ::bind [my organ text] <Control-z> [namespace code {my coroutine_abort}]
    ::coroutine [namespace current]::coroutine {*}$args
  }
  
  method coroutine_abort {} {
    ::catch {rename [namespace current]::coroutine {}}
    my signal normal
  }
  
  method script script {
    source $script
  }
  
  meta branchset signal normal {
    action {
::bind [my organ text] <Control-z>
my variable v
my configure prompt gort%
set v(tag) ok
my prompt {gort% }
my Enter
}
  }
  
  method prompt {{new {}}} {
    my variable v
    if {$new ne {}} {
      set v(prompt) $new
      set v(plength) [string length $v(prompt)]
    }
    #my <text> insert end $v(prompt)
    #my <text> mark set insert end
    #my <text> mark set out {insert linestart}
    #my <text> yview insert
  }
  
  method user_input {} {
    yield
    my variable v
    set result {}
    variable user_input
    if {[info exists user_input]} {
      set result $user_input
      set user_input {}
    }
    return $result
  }
  
  method Evaluate cmd {
    if {[info command [namespace current]::coroutine] ne {}} {
      set cmd [string trim $cmd]
      if {$cmd ne {}} {
        my variable user_input
        set user_input $cmd
      }
      set reply [[namespace current]::coroutine]
      if {[info command [namespace current]::coroutine] eq {}} {
        my signal normal
      }
      return $reply
    }
    set keyword [lindex $cmd 0]
    if {[info exists ::shell::cname($keyword)]} {
      set keyword $::shell::cname($keyword)
    }
    if {[string index $keyword 0] eq ":" || [info commands ::command::[lindex $keyword 0]] eq {}} {
      return [uplevel #0 $cmd]
    } else {
      my variable v
      set v(tag) grn
      set evalsc [concat ::command::[lindex $keyword 0] {*}[lrange $keyword 1 end] {*}[lrange $cmd 1 end]]
      return [uplevel #0 $evalsc]
    }
  }

  ###
  # topic: 024538860f333eb19ff207661c4841925e3f1984
  ###
  method Hull_Destroy {} {
    my variable ismain
    if { $ismain } {
      catch {rename ::console:puts ::puts}
    }
    next
  }
  
  ###
  # topic: 59323ec45d88b5f58e740f48761efdd4a79ac759
  ###
  method Hull_Populate {} {
    set w [my widget toplevel]
    set prompt [my cget prompt]
    set title  [my cget title]
    upvar #0 $w.t v
    if {[info exists v]} {unset v}
    wm title $w $title
    wm iconname $w $title
    my graft hull $w

    my build_buttons    
    my build_console
  }
}

namespace eval ::shell {}

proc ::shell::echo chan {
  appmain puts [::chan read $chan] black
  set ::shell::trace($chan) 1
}

proc ::shell::doexec args {
  try {
    set read [open |$args r]
    ::chan event $read readable [list ::shell::echo $read]
    while {![::chan eof $read]} {
      vwait ::shell::trace($read)
      update idletasks
    }
  } on error {e eo} {
    appmain puts "ERR: $e ($eo)" orange
  } finally {
    catch {close $read}
  }
}

###
# Remap the doexec to be console friendly
###
proc ::doexec args {
  try {
    set read [open |$args r]
    ::chan event $read readable [list ::shell::echo $read]
    while {![::chan eof $read]} {
      vwait ::shell::trace($read)
      update idletasks
    }
  } on error {e eo} {
    appmain puts "ERR: $e ($eo)" orange
  } finally {
    catch {close $read}
  }
}

proc ::command::exec {args} {
  try {
    set read [open |$args r]
    ::chan event $read readable [list ::shell::echo $read]
    while {![::chan eof $read]} {
      vwait ::shell::trace($read)
      update idletasks
    }
  } on error {e eo} {
    appmain puts "ERR: $e ($eo)" orange
  } finally {
    catch {close $read}
  }
}
