package require shed::db
package require http
tool::class create ::gort::content::shed_root {

  method content {} {
    my reset
    set formdata [my ReadForm]
    if {[llength $formdata]} {
      tailcall my SearchResult $formdata
    }
    my puts "<HTML><HEAD><TITLE>Shed Database Search</TITLE></HEAD><BODY>"
    my puts "Back to: <a href=/>Home</a><hr>"
    my puts "Browse by Class:<ul>"
    ::shed::db eval {select distinct shed_class from entity order by shed_class} {
      my puts "<li><a href=/shed/search?[::http::formatQuery topic $shed_class]>$shed_class</a>"
    }
    my puts "</ul>"
    
    my puts {</BODY></HTML>}
  }
  
  method SearchResult formdata {
    set pagesize 50
    set offset 0
    if {[dict exists $formdata rows]} {
      set pagesize $rows
    }
    if {[dict exists $formdata offset]} {
      set offset [dict get $formdata offset]
    }
    my puts "<HTML><HEAD><TITLE>Shed Database Search Results</TITLE></HEAD><BODY>"
    my puts "Back to: <a href=/>Home</a><hr>||<a gref=/shed>Search</a>"
    set stmtl {}
    if {[dict exists $formdata topic]} {
      set form(shed_class) [dict get $formdata topic]
      lappend stmtl shed_class=:form(shed_class)
    }
    if {[dict exists $formdata shed_class]} {
      set form(shed_class) [dict get $formdata shed_class]
      lappend stmtl shed_class=:form(shed_class)
    }
    if {[dict exists $formdata name]} {
      set form(name) [dict get $formdata name]
      lappend stmtl "name like :form(name)"
    }
    if {[dict exists $formdata version]} {
      set form(version) [dict get $formdata version]
      lappend stmtl "version=form(version)"
    }
    set buffer {}
    set rows 0
    my puts "<pre>$formdata</pre><p>"
    if {[llength $stmtl]} {
      set stmt "select * from entity where [join $stmtl " AND "] LIMIT :pagesize OFFSET :offset"
      my puts "<pre>$stmt</pre><p>"
      ::shed::db eval $stmt {
        incr rows
        append buffer "<tr><td><a href=/shed/uuid/$uuid>$uuid</td><td>$name</td><td>$version<td></tr>"
      }
    }
    if {$rows} {
      set navbar {}
      if {$offset>$pagesize} {
        set searchinfo $formdata
        dict set searchinfo offset [expr {$offset-$pagesize}]
        lappend navbar "<a href=\"/shed/search?[::http::formatQuery {*}$searchinfo]\">Prev $pagesize</a>"
      }
      if {$rows >= $pagesize} {
        set searchinfo $formdata
        dict set searchinfo offset [expr {$offset+$pagesize}]
        lappend navbar "<a href=\"/shed/search?[::http::formatQuery {*}$searchinfo]\">Next $pagesize</a>"
      }
      my puts "||[join $navbar ||]<br>"
      my puts "<TABLE><TR><TH>UUID</TH><TH>Name</TH><TH>Version</TH></TR>"
      my puts $buffer
      my puts "</TABLE>"
      my puts "<br>[join $navbar ||]"
    } else {
      my puts "<p>No search results returned"
    }
    my puts "</BODY></HTML>"
  }
}

tool::class create ::gort::content::shed_node {

  method content {} {
    set uuid [file tail [my query_headers get REQUEST_PATH]]
    my puts "<HTML><BODY>"
    my puts "<A HREF=/shed>SHED</A>||<A HREF=/shed/search>SEARCH</A>||<A HREF=\"[my query_headers get HTTP_REFERER]\">Back</a>"
    my puts "<table>"
    ::shed::db eval {select * from entity where uuid=:uuid} record break;
    foreach field $record(*) {
      my puts "<TR><td>$field</td><td colspan=2>$record($field)</td></tr>"
    }
    my puts "<TR><TD colspan=2><hr></tr>"
    ::shed::db eval {select field,value from meta where entity=:uuid} {
      my puts "<TR><TD>$field</TD><TD colspan=2>$value</TD></TR>"
    }
    my puts "<TR><TD colspan=2><hr></tr>"
    ::shed::db eval {select * from entity where uuid in (select fromid from link where toid=:uuid)} other {
      my puts "<TR><TD>$other(shed_class):</TD><TD>$other(name)</TD><TD><A HREF=\"$other(uuid)\">$other(uuid)</A></TD><TR>"
    }
    my puts "<TR><TD colspan=2><hr></tr>"
    set othertype {}
    set linktypes [::shed::db eval {select distinct linktype from link where fromid=:uuid}]
    foreach linktype $linktypes {
      my puts "<TR><TD colspan=2>$linktype</TD></tr>"
      ::shed::db eval {select * from entity where uuid in (select toid from link where fromid=:uuid and linktype=:linktype)} other {
        my puts "<TR><TD>$other(shed_class):</TD><td>$other(name)</td><TD><A HREF=\"$other(uuid)\">$other(uuid)</A></TD><TR>"
      }
    }
    my puts "</TABLE>"
    my puts "</BODY></HTML>"
  }
}
appmain add_uri /shed/uuid/* {mixin ::gort::content::shed_node}
appmain add_uri /shed {mixin ::gort::content::shed_root}
#appmain add_uri /shed?* {mixin ::gort::content::shed_root}
appmain add_uri /shed/search {mixin ::gort::content::shed_root}
#appmain add_uri /shed/search?* {mixin ::gort::content::shed_root}
