###
# Recipe section
###
package require gort::recipes
tool::class create ::gort::content::recipe_root {
  method content {} {
    my reset
    my puts "<HTML><HEAD><TITLE>Gort Recipes</TITLE></HEAD><BODY>"
    global recipe
    my puts "<UL>"
    foreach mod [lsort -dictionary [array names ::gort::info]] {
      my puts "<LI><A HREF=/recipe/$mod>$mod</A></LI>"
    }
    my puts {</UL></BODY></HTML>}
  }
}

tool::class create ::gort::content::recipe_node {
  
  method RecipeObj module {
    set obj [::gort::recipe_object $module]
    return $obj

    if {[info exists ::recipe_group($module)]} {
      set result {}
      foreach rec $::recipe_group($module) {
        set obj [::gort::recipe_object $rec]
        lappend result $obj
      }
      return $result
    } else {
      set obj [::gort::recipe_object $module]
      return $obj
    }
  }
  
  method content {} {
    my reset
    set uri    [my query_headers get REQUEST_URI]
    set prefix [my query_headers get prefix]
    set module [string range $uri [string length $prefix]+1 end]
    set objlist [my RecipeObj $module]
    if {[llength $objlist] eq 0 } {
      tailcall my error 400 {Recipe does not exist}
    }
    my puts "<HTML><HEAD><TITLE>Recipe $module</TITLE></HEAD><BODY>"
    my puts "<a href=\"/recipe\">Back</a>"
    foreach obj $objlist {
      my puts "<h1>[$obj package_name]</h1>"
      my puts "<table><tr><th>field</th><th>value</th></tr>"
      foreach {field value} $::gort::info($module) {
        if {$field eq "oo_define"} continue
        my puts "<tr><td>$field</td><td>$value</td></tr>"
      }
      my puts "<tr><td>oo_define</td><td><pre><code>[dict getnull $::gort::info($module) oo_define]</code></pre></td></tr>"
      my puts "</table>"
    }
    my puts "</BODY></HTML>"
  } 
}


appmain add_uri /recipe {mixin ::gort::content::recipe_root}
appmain add_uri /recipe/* {mixin ::gort::content::recipe_node}
