tool::class create ::gort::content::fossil_root {
  method content {} {
    my reset
    my puts "<HTML><HEAD><TITLE>Local Fossil Repositories</TITLE></HEAD><BODY>"
    global recipe
    my puts "<UL>"
    set dbfiles {}
    lappend dbfiles {*}[glob -nocomplain [file join $::gort(download) *fos]]                     
    lappend dbfiles {*}[glob -nocomplain [file join $::gort(download) *.fossil]]
    lappend dbfiles {*}[glob -nocomplain [file join $::gort(download) fossil *fos]]
    lappend dbfiles {*}[glob -nocomplain [file join $::gort(download) fossil *.fossil]]
    foreach file $dbfiles  {
      dict set result [file rootname [file tail $file]] $file
    }
    foreach {module dbfile} $result {
      my puts "<li><a HREF=/fossil/$module>$module</a>"
    }
    my puts {</UL></BODY></HTML>}
  }
}

###
# Fossil nodes are actually handoffs to fossil passthrough handlers
###
tool::class create ::gort::content::fossil_node_scgi {
  superclass httpd::content::scgi
  
  method scgi_info {} {
    set uri    [my query_headers get REQUEST_URI]
    set prefix [my query_headers get prefix]
    set module [lindex [split $uri /] 2]
    if {![info exists ::fossil_process($module)]} {
      package require processman
      package require nettool
      set port [::nettool::allocate_port 40000]
      set handle fossil:$port
      set dbfile [::gort::fossil_db $module]
      if {![file exists $dbfile]} {
        tailcall my error 400 {Not Found}
      }
      set mport [my <server> port_listening]
      set cmd [list $::gort(fossil) server $dbfile --port $port --localhost --scgi  2>/tmp/$module.err >/tmp/$module.log]

      dict set ::fossil_process($module) port $port
      dict set ::fossil_process($module) handle $handle
      dict set ::fossil_process($module) cmd $cmd
      dict set ::fossil_process($module) SCRIPT_NAME $prefix/$module
    }
    dict with ::fossil_process($module) {}
    if {![::processman::running $handle]} {
      set process [::processman::spawn $handle {*}$cmd]
      my varname paused
      after 500
    }
    return [list localhost $port $SCRIPT_NAME]
  }
}

tool::class create ::gort::content::fossil_node_proxy {
  superclass httpd::content::proxy
  
  method proxy_info {} {
    set uri    [my query_headers get REQUEST_URI]
    set prefix [my query_headers get prefix]
    set prefix [string trimright $prefix *]
    set prefix [string trimright $prefix /]
    set module [lindex [split $uri /] 2]
    #set module [lindex [split [string range $uri [string length $prefix] end] /] 0]
    if {![info exists ::fossil_process($module)]} {
      package require processman
      package require nettool
      set port [::nettool::allocate_port 40000]
      set handle fossil:$port
      set dbfile [::gort::fossil_db $module]
      if {![file exists $dbfile]} {
        tailcall my error 400 {Not Found}
      }
      set mport [my <server> port_listening]
      set cmd [list $::gort(fossil) server $dbfile --port $port --localhost --baseurl http://[my query_headers get HTTP_HOST]$prefix/$module 2>/tmp/$module.err >/tmp/$module.log]
      dict set ::fossil_process($module) port $port
      dict set ::fossil_process($module) handle $handle
      dict set ::fossil_process($module) cmd $cmd
      dict set ::fossil_process($module) SCRIPT_NAME $prefix/$module
    }
    dict with ::fossil_process($module) {}
    if {![::processman::running $handle]} {
      set process [::processman::spawn $handle {*}$cmd]
      my varname paused
      after 250
    }
    set rawreq    [my query_headers get REQUEST_RAW]
    set URI [string range [lindex $rawreq 1] [string length $prefix/$module] end]
    if {$URI eq {}} {
      set URI /
    }
    set proxyuri "[lindex $rawreq 0] $URI [lindex $rawreq 2]"
    return [list localhost $port $proxyuri]
  }
}

appmain add_uri /fossil {mixin ::gort::content::fossil_root}
appmain add_uri /fossil/* {mixin ::gort::content::fossil_node_scgi}