###
# We server for Sherpa
###

set HERE [file dirname [file join [pwd] [info script]]]
package require tool
package require httpd 4.0
package require httpd::content

set ::doc_root [file join $HERE server htdocs] 
if {[lindex $argv 0] eq "scgi"} {
  package require scgi::app
  set ::MODE scgi
  tool::class create ::gort::reply {
    superclass ::scgi::reply
  }
  tool::class create ::gort::server {
    superclass httpd::server::dispatch ::scgi::app
  }
  
} else {
  package require httpd 4.0
  set ::MODE http
  tool::class create ::gort::reply {
    superclass ::httpd::reply
  }
  tool::class create ::gort::server {
    superclass httpd::server::dispatch ::httpd::server
  }
}

tool::define ::gort::server {
  property reply_class ::gort::reply
  
  destructor {
    next
    # Kill any processes we have spawned
    ::processman::kill_all
  }
}
::gort::server create appmain doc_root $::doc_root {*}[lrange $argv 1 end]
::tool::pathload [file join $HERE server]
::tool::main
